/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.TriggerListener;
import java.sql.Connection;

public final class MckoiConnection {
    private MConnection connection;

    public MckoiConnection(Connection connection) {
        if (!(connection instanceof MConnection)) {
            throw new Error("Can only wrap a Mckoi Database JDBC connection.");
        }
        this.connection = (MConnection)connection;
    }

    public void setStrictGetObject(boolean status) {
        this.connection.setStrictGetObject(status);
    }

    public void setVerboseColumnNames(boolean status) {
        this.connection.setVerboseColumnNames(status);
    }

    public void addTriggerListener(String trigger_name, TriggerListener trigger_listener) {
        this.connection.addTriggerListener(trigger_name, trigger_listener);
    }

    public void removeTriggerListener(String trigger_name, TriggerListener trigger_listener) {
        this.connection.removeTriggerListener(trigger_name, trigger_listener);
    }

    public static String quote(String java_string) {
        StringBuffer buf = new StringBuffer();
        int str_len = java_string.length();
        for (int i = 0; i < str_len; ++i) {
            char c = java_string.charAt(i);
            if (c == '\'' || c == '\\') {
                buf.append('\\');
            }
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\r') {
                buf.append("\\r");
                continue;
            }
            if (c == '\t') {
                buf.append("\\t");
                continue;
            }
            buf.append(c);
        }
        return new String(buf);
    }
}

